package w83a.w83aBeans;

import java.sql.ResultSet;
import java.util.List;

import w83a.util.jdbc.W83aDataBase;
import w83a.w83aDAO.w83aConstantesBD.W83aBaseBeanBD;
import w83a.w83aDAO.w83aConstantesBD.W83aIncidenciasVistaBD;
import w83a.w83aUtilidadesComunes.W83aClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

/**
 * 
 * 
 * @author jroncal
 * 
 */
public class W83aIncidenciasBean extends W83aBaseBean implements W83aBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	String territorioIncidenciaDesde = "";
	String anyoIncidenciaDesde = "";
	String numIncidenciaDesde = "";
	
	String territorioIncidenciaHasta = "";
	String anyoIncidenciaHasta = "";
	String numIncidenciaHasta = "";
	
	String territorioActaDesde = "";
	String anyoActaDesde = "";
	String numActaDesde = ""; 
	
	String territorioActaHasta = "";
	String anyoActaHasta = "";
	String numActaHasta = ""; 
	
	String fechaEntradaDesde = "";
	String fechaEntradaHasta = "";
	
	String tipoSolicitante = "";
	String tipoSolicitanteTxt = "";
	String dniSolicitante = "";
	String nombreSolicitante = "";
	
	String tipologiaIncidencia = "";
	String tipologiaIncidenciaTxt = "";
	
	String tramite = "";
	String tramiteTxt = "";
	String fechaTramiteDesde = "";
	String fechaTramiteHasta = "";
	String ultimoTramite = "";
	
	String fechaEntrada = "";
	String numActa = "";
	String tipSolicitante = "";
	String tipSolicitanteCast = "";
	String tipSolicitanteEusk = "";
	String solicitante = "";
	String tipologia = "";
	String tipologiaCast = "";
	String tipologiaEusk = "";	
	
	String territorioIncidencia = "";
	String anyoIncidencia = "";
	String numIncidencia = "";
	String numIncidenciaSencillo = "";
	String numIncidenciaCompleto = "";
	
	String territorioActa = "";
	String anyoActa = "";
	String numActaSencillo = "";
	String versionActa = "";
	
	String flagValidada = "";
	
	String flagBusqValidada = "";
	String flagBusqNoValidada = "";
	String flagBusqDescartada = "";
	
	String razon = "";
	
	String fechaValidacion = "";
	
	String numRegDef = "";
	String fechaRegDef = "";
	
	
	
	public String getNumRegDef() {
		return numRegDef;
	}

	public void setNumRegDef(String numRegDef) {
		this.numRegDef = numRegDef;
	}

	public String getFechaRegDef() {
		return fechaRegDef;
	}

	public void setFechaRegDef(String fechaRegDef) {
		this.fechaRegDef = fechaRegDef;
	}

	public String getFechaValidacion() {
		return fechaValidacion;
	}

	public void setFechaValidacion(String fechaValidacion) {
		this.fechaValidacion = fechaValidacion;
	}

	public String getRazon() {
		return razon;
	}

	public void setRazon(String razon) {
		this.razon = razon;
	}

	public String getNumIncidenciaCompleto() {
		return numIncidenciaCompleto;
	}

	public void setNumIncidenciaCompleto(String numIncidenciaCompleto) {
		this.numIncidenciaCompleto = numIncidenciaCompleto;
	}

	public String getNumIncidenciaSencillo() {
		return numIncidenciaSencillo;
	}

	public void setNumIncidenciaSencillo(String numIncidenciaSencillo) {
		this.numIncidenciaSencillo = numIncidenciaSencillo;
	}

	public String getFlagValidada() {
		return flagValidada;
	}
	
	public String getNoValidadaFalse() {
		if(!W83aClsConstantes.CONSTANTE_NO_VALIDADA.equals(flagValidada)){
			return "true";
		}else{
			return "false";
		}
	}
	
	public String getFlagValidadaTxtES() throws Q70GestorMensajesException {
		if(W83aClsConstantes.CONSTANTE_NO_VALIDADA.equals(flagValidada)){
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.noValidada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase();
		}else if(W83aClsConstantes.CONSTANTE_VALIDADA.equals(flagValidada)){
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.validada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase();			
		}else{
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.descartada",W83aClsConstantes.CONSTANTE_CASTELLANO).toUpperCase();
		}
	}
	
	public String getFlagValidadaTxtEU() throws Q70GestorMensajesException {
		if(W83aClsConstantes.CONSTANTE_NO_VALIDADA.equals(flagValidada)){
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.noValidada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase();
		}else if(W83aClsConstantes.CONSTANTE_VALIDADA.equals(flagValidada)){
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.validada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase();			
		}else{
			return Q70GestorMensajesi18n.getSingleton().getMessage("w83acomun","comun.incidencias.descartada",W83aClsConstantes.CONSTANTE_EUSKARA).toUpperCase();
		}
	}

	public void setFlagValidada(String flagValidada) {
		this.flagValidada = flagValidada;
	}

	public String getVersionActa() {
		return versionActa;
	}

	public void setVersionActa(String versionActa) {
		this.versionActa = versionActa;
	}

	public String getTerritorioActa() {
		return territorioActa;
	}

	public void setTerritorioActa(String territorioActa) {
		this.territorioActa = territorioActa;
	}

	public String getAnyoActa() {
		return anyoActa;
	}

	public void setAnyoActa(String anyoActa) {
		this.anyoActa = anyoActa;
	}

	public String getNumActaSencillo() {
		return numActaSencillo;
	}

	public void setNumActaSencillo(String numActaSencillo) {
		this.numActaSencillo = numActaSencillo;
	}

	public String getTerritorioIncidencia() {
		return territorioIncidencia;
	}

	public void setTerritorioIncidencia(String territorioIncidencia) {
		this.territorioIncidencia = territorioIncidencia;
	}

	public String getAnyoIncidencia() {
		return anyoIncidencia;
	}

	public void setAnyoIncidencia(String anyoIncidencia) {
		this.anyoIncidencia = anyoIncidencia;
	}

	public String getNumIncidencia() {
		return numIncidencia;
	}

	public void setNumIncidencia(String numIncidencia) {
		this.numIncidencia = numIncidencia;
	}

	/** The lista docs. */
	private List listaDocs;
	
	

	public List getListaDocs() {
		return listaDocs;
	}

	public void setListaDocs(List listaDocs) {
		this.listaDocs = listaDocs;
	}

	public String getTerritorioIncidenciaDesde() {
		return territorioIncidenciaDesde;
	}

	public void setTerritorioIncidenciaDesde(String territorioIncidenciaDesde) {
		this.territorioIncidenciaDesde = territorioIncidenciaDesde;
	}

	public String getAnyoIncidenciaDesde() {
		return anyoIncidenciaDesde;
	}

	public void setAnyoIncidenciaDesde(String anyoIncidenciaDesde) {
		this.anyoIncidenciaDesde = anyoIncidenciaDesde;
	}

	public String getNumIncidenciaDesde() {
		return numIncidenciaDesde;
	}

	public void setNumIncidenciaDesde(String numIncidenciaDesde) {
		this.numIncidenciaDesde = numIncidenciaDesde;
	}

	public String getTerritorioIncidenciaHasta() {
		return territorioIncidenciaHasta;
	}

	public void setTerritorioIncidenciaHasta(String territorioIncidenciaHasta) {
		this.territorioIncidenciaHasta = territorioIncidenciaHasta;
	}

	public String getAnyoIncidenciaHasta() {
		return anyoIncidenciaHasta;
	}

	public void setAnyoIncidenciaHasta(String anyoIncidenciaHasta) {
		this.anyoIncidenciaHasta = anyoIncidenciaHasta;
	}

	public String getNumIncidenciaHasta() {
		return numIncidenciaHasta;
	}

	public void setNumIncidenciaHasta(String numIncidenciaHasta) {
		this.numIncidenciaHasta = numIncidenciaHasta;
	}

	public String getTerritorioActaDesde() {
		return territorioActaDesde;
	}

	public void setTerritorioActaDesde(String territorioActaDesde) {
		this.territorioActaDesde = territorioActaDesde;
	}

	public String getAnyoActaDesde() {
		return anyoActaDesde;
	}

	public void setAnyoActaDesde(String anyoActaDesde) {
		this.anyoActaDesde = anyoActaDesde;
	}

	public String getNumActaDesde() {
		return numActaDesde;
	}

	public void setNumActaDesde(String numActaDesde) {
		this.numActaDesde = numActaDesde;
	}

	public String getTerritorioActaHasta() {
		return territorioActaHasta;
	}

	public void setTerritorioActaHasta(String territorioActaHasta) {
		this.territorioActaHasta = territorioActaHasta;
	}

	public String getAnyoActaHasta() {
		return anyoActaHasta;
	}

	public void setAnyoActaHasta(String anyoActaHasta) {
		this.anyoActaHasta = anyoActaHasta;
	}

	public String getNumActaHasta() {
		return numActaHasta;
	}

	public void setNumActaHasta(String numActaHasta) {
		this.numActaHasta = numActaHasta;
	}

	public String getFechaEntradaDesde() {
		return fechaEntradaDesde;
	}

	public void setFechaEntradaDesde(String fechaEntradaDesde) {
		this.fechaEntradaDesde = fechaEntradaDesde;
	}

	public String getFechaEntradaHasta() {
		return fechaEntradaHasta;
	}

	public void setFechaEntradaHasta(String fechaEntradaHasta) {
		this.fechaEntradaHasta = fechaEntradaHasta;
	}

	public String getDniSolicitante() {
		return dniSolicitante;
	}

	public void setDniSolicitante(String dniSolicitante) {
		this.dniSolicitante = dniSolicitante;
	}

	public String getTipoSolicitante() {
		return tipoSolicitante;
	}

	public void setTipoSolicitante(String tipoSolicitante) {
		this.tipoSolicitante = tipoSolicitante;
	}

	public String getNombreSolicitante() {
		return nombreSolicitante;
	}

	public void setNombreSolicitante(String nombreSolicitante) {
		this.nombreSolicitante = nombreSolicitante;
	}

	public String getTipologiaIncidencia() {
		return tipologiaIncidencia;
	}

	public void setTipologiaIncidencia(String tipologiaIncidencia) {
		this.tipologiaIncidencia = tipologiaIncidencia;
	}

	public String getTramite() {
		return tramite;
	}

	public void setTramite(String tramite) {
		this.tramite = tramite;
	}

	public String getFechaTramiteDesde() {
		return fechaTramiteDesde;
	}

	public void setFechaTramiteDesde(String fechaTramiteDesde) {
		this.fechaTramiteDesde = fechaTramiteDesde;
	}

	public String getFechaTramiteHasta() {
		return fechaTramiteHasta;
	}

	public void setFechaTramiteHasta(String fechaTramiteHasta) {
		this.fechaTramiteHasta = fechaTramiteHasta;
	}

	public String getUltimoTramite() {
		return ultimoTramite;
	}

	public void setUltimoTramite(String ultimoTramite) {
		this.ultimoTramite = ultimoTramite;
	}
	
	public String getFechaEntrada() {
		return fechaEntrada;
	}

	public void setFechaEntrada(String fechaEntrada) {
		this.fechaEntrada = fechaEntrada;
	}

	public String getTipSolicitante() {
		return tipSolicitante;
	}

	public void setTipSolicitante(String tipSolicitante) {
		this.tipSolicitante = tipSolicitante;
	}

	public String getSolicitante() {
		return solicitante;
	}

	public void setSolicitante(String solicitante) {
		this.solicitante = solicitante;
	}

	public String getTipologia() {
		return tipologia;
	}

	public void setTipologia(String tipologia) {
		this.tipologia = tipologia;
	}

	public void setNumActa(String numActa) {
		this.numActa = numActa;
	}
	
	public String getTipSolicitanteCast() {
		return tipSolicitanteCast;
	}

	public void setTipSolicitanteCast(String tipSolicitanteCast) {
		this.tipSolicitanteCast = tipSolicitanteCast;
	}

	public String getTipSolicitanteEusk() {
		return tipSolicitanteEusk;
	}

	public void setTipSolicitanteEusk(String tipSolicitanteEusk) {
		this.tipSolicitanteEusk = tipSolicitanteEusk;
	}

	public String getTipologiaCast() {
		return tipologiaCast;
	}

	public void setTipologiaCast(String tipologiaCast) {
		this.tipologiaCast = tipologiaCast;
	}

	public String getTipologiaEusk() {
		return tipologiaEusk;
	}

	public void setTipologiaEusk(String tipologiaEusk) {
		this.tipologiaEusk = tipologiaEusk;
	}

	public String getNumActa() {
		return numActa;
	}

	public String getTipoSolicitanteTxt() {
		return tipoSolicitanteTxt;
	}

	public void setTipoSolicitanteTxt(String tipoSolicitanteTxt) {
		this.tipoSolicitanteTxt = tipoSolicitanteTxt;
	}

	public String getTipologiaIncidenciaTxt() {
		return tipologiaIncidenciaTxt;
	}

	public void setTipologiaIncidenciaTxt(String tipologiaIncidenciaTxt) {
		this.tipologiaIncidenciaTxt = tipologiaIncidenciaTxt;
	}

	public String getTramiteTxt() {
		return tramiteTxt;
	}

	public void setTramiteTxt(String tramiteTxt) {
		this.tramiteTxt = tramiteTxt;
	}

	public String getFlagBusqValidada() {
		return flagBusqValidada;
	}

	public void setFlagBusqValidada(String flagBusqValidada) {
		this.flagBusqValidada = flagBusqValidada;
	}

	public String getFlagBusqNoValidada() {
		return flagBusqNoValidada;
	}

	public void setFlagBusqNoValidada(String flagBusqNoValidada) {
		this.flagBusqNoValidada = flagBusqNoValidada;
	}

	public String getFlagBusqDescartada() {
		return flagBusqDescartada;
	}

	public void setFlagBusqDescartada(String flagBusqDescartada) {
		this.flagBusqDescartada = flagBusqDescartada;
	}

	public boolean isNullBusq(){
		if(null == territorioIncidenciaDesde  &&
			null == anyoIncidenciaDesde  &&
			null == numIncidenciaDesde  &&
		
			null == territorioIncidenciaHasta  &&
			null == anyoIncidenciaHasta  &&
			null == numIncidenciaHasta  &&
		
			null == territorioActaDesde  &&
			null == anyoActaDesde  &&
			null == numActaDesde  && 
		
			null == territorioActaHasta  &&
			null == anyoActaHasta  &&
			null == numActaHasta  && 
		
			null == fechaEntradaDesde  &&
			null == fechaEntradaHasta  &&
		
			null == tipoSolicitante  &&
			null == dniSolicitante  &&
			null == nombreSolicitante  &&
		
			null == tipologiaIncidencia  &&
		
			null == tramite  &&
			null == fechaTramiteDesde  &&
			null == fechaTramiteHasta  &&
			null == ultimoTramite ){
			return true;
		}
		return false;
	}

	/**
	 * 
	 * El constructor de W83aIncidenciasBean.
	 */
	public W83aIncidenciasBean() {
		super();
	}

	public Object rowToBean(Object o, Object otrosValores) throws Exception {
		// TODO Auto-generated method stub
		ResultSet rs = (ResultSet)o;//NOPMD
		
		this.fechaEntrada = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.fentrada);
		this.numActa = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.numacta);
		this.tipSolicitante = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipsolicitante);
		this.tipSolicitanteCast = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipsolicitante_es);
		this.tipSolicitanteEusk = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipsolicitante_eu);
		this.solicitante = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.nomsolicitante);
		this.tipologia = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipincidencia);		
		this.tipologiaCast = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipincidencia_es);		
		this.tipologiaEusk = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.tipincidencia_eu);	
		
		this.territorioIncidencia = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.territorioincidencias);	
		this.anyoIncidencia = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.anyoincidencias);	
		this.numIncidencia = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.nincidencias);
		this.numIncidenciaSencillo = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.numincidenciasencillocompleto);
		this.numIncidenciaCompleto = W83aDataBase.getStringFromRS(rs, "NINCIDENCIACOMPLETO");
		
		this.territorioActa = this.territorioIncidencia;	
		this.anyoActa = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.anyoacta);	
		this.numActaSencillo = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.nacta);	
		this.versionActa = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.versionActa);	
		
		this.flagValidada = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.flagvalidada);
		this.razon = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.razon);
		
		this.numRegDef = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.numRegDef);
		this.fechaRegDef = W83aDataBase.getStringFromRS(rs, W83aIncidenciasVistaBD.fechaRegDef);
		
		return this;
	}
}
